--
-- Table structure for table `a_account`
--

CREATE TABLE `a_account` (
  `account_id` bigint NOT NULL,
  `login` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `role` varchar(64) NOT NULL DEFAULT '',
  `fullname` varchar(100) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `a_groups`
--

CREATE TABLE `a_groups` (
  `group_id` int NOT NULL,
  `name` varchar(100) NOT NULL,
  `course_id` bigint NOT NULL DEFAULT '0',
  `date` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `moodle_cohort_id` bigint NOT NULL DEFAULT '0',
  `moodle_group_id` bigint NOT NULL DEFAULT '0',
  `moodle_enrol_id` bigint NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `a_groups_users`
--

CREATE TABLE `a_groups_users` (
  `user_id` bigint NOT NULL DEFAULT '0',
  `group_id` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `a_organizations`
--

CREATE TABLE `a_organizations` (
  `organization_id` int NOT NULL,
  `name` varchar(250) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `a_positions`
--

CREATE TABLE `a_positions` (
  `position_id` int NOT NULL,
  `name` varchar(250) NOT NULL DEFAULT '',
  `qualification_id` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `a_qualifications`
--

CREATE TABLE `a_qualifications` (
  `qualification_id` int NOT NULL,
  `name` varchar(250) NOT NULL DEFAULT '',
  `course` varchar(100) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `a_reports`
--

CREATE TABLE `a_reports` (
  `user_id` bigint NOT NULL DEFAULT '0',
  `num` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `course` varchar(250) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `course_id` bigint NOT NULL DEFAULT '0',
  `date` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `result` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `a_session`
--

CREATE TABLE `a_session` (
  `token` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `account_id` bigint NOT NULL DEFAULT '0',
  `time_session` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `a_users`
--

CREATE TABLE `a_users` (
  `user_id` bigint NOT NULL,
  `lastname` varchar(100) NOT NULL DEFAULT '',
  `firstname` varchar(100) NOT NULL DEFAULT '',
  `middlename` varchar(100) NOT NULL DEFAULT '',
  `login` varchar(20) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `organization_id` int NOT NULL DEFAULT '0',
  `subdivision` varchar(200) NOT NULL DEFAULT '',
  `position_id` int NOT NULL DEFAULT '0',
  `date_of_birth` varchar(64) NOT NULL DEFAULT '',
  `cart_id` varchar(64) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `a_account`
--
ALTER TABLE `a_account`
  ADD PRIMARY KEY (`account_id`),
  ADD UNIQUE KEY `login` (`login`);

--
-- Indexes for table `a_groups`
--
ALTER TABLE `a_groups`
  ADD PRIMARY KEY (`group_id`),
  ADD KEY `name` (`name`);

--
-- Indexes for table `a_groups_users`
--
ALTER TABLE `a_groups_users`
  ADD KEY `user_id` (`user_id`),
  ADD KEY `group_id` (`group_id`);

--
-- Indexes for table `a_organizations`
--
ALTER TABLE `a_organizations`
  ADD PRIMARY KEY (`organization_id`),
  ADD KEY `name` (`name`);

--
-- Indexes for table `a_positions`
--
ALTER TABLE `a_positions`
  ADD PRIMARY KEY (`position_id`),
  ADD KEY `name` (`name`),
  ADD KEY `qualification_id` (`qualification_id`);

--
-- Indexes for table `a_qualifications`
--
ALTER TABLE `a_qualifications`
  ADD PRIMARY KEY (`qualification_id`),
  ADD KEY `name` (`name`);

--
-- Indexes for table `a_reports`
--
ALTER TABLE `a_reports`
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `a_session`
--
ALTER TABLE `a_session`
  ADD UNIQUE KEY `session` (`token`),
  ADD UNIQUE KEY `token` (`token`),
  ADD KEY `time_session` (`time_session`);

--
-- Indexes for table `a_users`
--
ALTER TABLE `a_users`
  ADD PRIMARY KEY (`user_id`),
  ADD KEY `lastname` (`lastname`),
  ADD KEY `login` (`login`),
  ADD KEY `email` (`email`),
  ADD KEY `position_id` (`position_id`),
  ADD KEY `organization_id` (`organization_id`),
  ADD KEY `cart_id` (`cart_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `a_account`
--
ALTER TABLE `a_account`
  MODIFY `account_id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `a_groups`
--
ALTER TABLE `a_groups`
  MODIFY `group_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `a_organizations`
--
ALTER TABLE `a_organizations`
  MODIFY `organization_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `a_positions`
--
ALTER TABLE `a_positions`
  MODIFY `position_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `a_qualifications`
--
ALTER TABLE `a_qualifications`
  MODIFY `qualification_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `a_users`
--
ALTER TABLE `a_users`
  MODIFY `user_id` bigint NOT NULL AUTO_INCREMENT;
COMMIT;
