<?php
/**
 * @copyright 2022
 */


require_once 'config.php';
$dbhost = $cfg->host;
$dbuser = $cfg->user;
$dbpassword = $cfg->password;
$dbname = $cfg->name;


try {  
    $dbh = new PDO("mysql:host=$dbhost;dbname=$dbname;charset=utf8", $dbuser, $dbpassword);  
}  
catch(PDOException $e) {  
    echo $e->getMessage();  
}



session_start();
$userid = 0;    // User id.

/*if (!$user = $DB->get_record('user', array('id' => $userid))) {
    print_error('invaliduserid');
}




if(is_siteadmin() )
    $is_admin = "true";
else    
    $is_admin = "";





if (!isset($_SESSION['user_id']) or $_SESSION['user_id']==0 or $_SESSION['user_id']=='') {
    $user_id_session = 0;
    $customer_id  = 0;

    $rc_list = [ "status"=>"1", "error"=>'No auth' ];
    $result = ["isSysAdmin"=>0, "customerId"=>0, "userId"=>0, "action"=>"action", "result"=>$rc_list];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
    return 0;
}

$user_id_session = $_SESSION['user_id'];
$stmt = $dbh->prepare('SELECT `customer_id`,`role` FROM `users` WHERE `user_id`=? ');
$stmt->execute([$user_id_session]); 
if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
    $customer = $row->customer_id;
    if($row->role == 'admin')
    $is_siteadmin = 1;
}

#echo $user_id; 
*/


//$api_function = '';
//$api_arg = [];

$_JSON =  json_decode(file_get_contents('php://input'), true);
foreach ($_JSON as $key => $value) {
    $api_function = $key;
    $api_arg = $value;
    break; 
}

//$api_function='users_list';

require_once  'api_core.php';

/* USERS */

function users_list($is_search, $lastname, $firstname, $middlename, $organization, $page) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    $offset=0;
    if( $page>1 ){
	$offset = intval($page)*100;
    }
    else {
	 $page=1;
    }

    $users_list = [];
    $members = 0;

    if($is_search >0){
	if($organization>0){
	    $stmt = $dbh->prepare('SELECT `user_id`, `login`, `lastname`, `firstname`, `middlename`, `email`, `organization_id`, `position_id`  FROM `a_users` WHERE `lastname` LIKE ? AND `firstname` LIKE ? AND  `middlename` LIKE ? AND `organization_id`=?  ORDER BY `lastname` LIMIT 100  OFFSET ' . "$offset");
    	    $stmt->execute(["$lastname%", "$firstname%", "$middlename%", $organization,]);
	}
	else {
	    $stmt = $dbh->prepare('SELECT `user_id`, `login`, `lastname`, `firstname`, `middlename`, `email`, `organization_id`, `position_id`  FROM `a_users` WHERE `lastname` LIKE ? AND `firstname` LIKE ? AND  `middlename` LIKE ?  ORDER BY `lastname` LIMIT 100  OFFSET  ' . "$offset");
    	    $stmt->execute(["$lastname%", "$firstname%", "$middlename%"]);
	}
    }
    else {
	$stmt = $dbh->query('SELECT `user_id`, `login`, `lastname`, `firstname`, `middlename`, `email`, `organization_id`, `position_id`  FROM `a_users`   ORDER BY `lastname`  LIMIT 100  OFFSET  ' . "$offset");
    }
    while($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $organization_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_organizations`  WHERE `organization_id`=? ');
    	    $stmt2->execute([$row->organization_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$organization_name = $row2->name;
	    }
	    $position_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_positions`  WHERE `position_id`=? ');
    	    $stmt2->execute([$row->position_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$position_name = $row2->name;
	    }

	    $users_list[] =  ["userId"=>$row->user_id, "login"=>$row->login, "lastname"=>$row->lastname, "firstname"=>$row->firstname, "middlename"=>$row->middlename, "organization"=>$organization_name, "position"=>$position_name ];
    }


    if($is_search >0){
	if($organization>0){
	    $stmt0 = $dbh->prepare('SELECT SELECT count(*) as `count`    FROM `a_users` WHERE `lastname` LIKE ? AND `firstname` LIKE ? AND  `middlename` LIKE ? AND `organization_id`=?');
    	    $stmt0->execute(["$lastname%", "$firstname%", "$middlename%", $organization]);
	}
	else {
	    $stmt0 = $dbh->prepare('SELECT count(*) as `count`  FROM `a_users` WHERE `lastname` LIKE ? AND `firstname` LIKE ? AND  `middlename` LIKE ? ');
    	    $stmt0->execute(["$lastname%", "$firstname%", "$middlename%"]);
	}
    }
    else {
	$stmt0 = $dbh->query('SELECT count(*) as `count`   FROM `a_users`   ');
    }
    if($row0 = $stmt0->fetch(PDO::FETCH_OBJ)) {  
	$members = $row0->count;
    }
    $num_pages = intval(($members)/100);
    if( $page > $num_pages ){
	    $page = $num_pages;
    }

    //$result = ["role"=>$session_role, "action"=>"users_list", "userId"=>$user_id_session, "result"=>$rc_list, "numPages"=>$members];
    $result = ["role"=>$session_role, "action"=>"users_list",  "list"=>$users_list,  "search"=>$is_search, "numPages"=>$num_pages, "page"=>$page];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}


function user_detalies($user_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    /*if($user_id == 0)
        $a_user_id = $user_id_session;
    else
        $a_user_id = $user_id;
    */

    $rc =  ["user_id"=>0,  "lastname"=>'', "firstname"=>'', "middlename"=>'', "login"=>'',  "password"=>'', "organization_id"=>0, "position_id"=>0, "organization"=>'', "position"=>'', "subdivision"=>'', "date_of_birth"=>'', "cart_id"=>'' ];
    if($user_id >0 ) {
	$stmt = $dbh->prepare('SELECT  `user_id`,  `lastname`, `firstname`, `middlename`, `email`, `login`, `password`,  `organization_id`, `position_id`, `subdivision`, `date_of_birth`, `cart_id`  FROM `a_users`   WHERE `user_id`=?');
	$stmt->execute([$user_id]);
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $organization_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_organizations`  WHERE `organization_id`=? ');
    	    $stmt2->execute([$row->organization_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$organization_name = $row2->name;
	    }
	    $position_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_positions`  WHERE `position_id`=? ');
    	    $stmt2->execute([$row->position_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$position_name = $row2->name;
	    }

	    $rc =  ["user_id"=>$row->user_id, "lastname"=>$row->lastname, "firstname"=>$row->firstname, "middlename"=>$row->middlename, "email_lms"=>$row->email, "login"=>$row->login,  "password"=>$row->password, "organization_id"=>$row->organization_id, "position_id"=>$row->position_id, "organization"=>$organization_name, "position"=>$position_name, "subdivision"=>$row->subdivision, "date_of_birth"=>$row->date_of_birth, "cart_id"=>$row->cart_id ];
	}
    }
    $result = ["role"=>$session_role, "action"=>"user", "userId"=>$user_id_session, "userInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function user_view($cart_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    if($cart_id >0 ) {
	$stmt = $dbh->prepare('SELECT  `user_id`   FROM `a_users`   WHERE `cart_id`=?');
	$stmt->execute([$cart_id]);
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    return user_detalies($row->user_id);
	}
    }
    $rc =  ["user_id"=>0,  "lastname"=>'', "firstname"=>'', "middlename"=>'', "login"=>'',  "password"=>'', "organization_id"=>0, "position_id"=>0, "organization"=>'', "position"=>'', "subdivision"=>'', "date_of_birth"=>'' ];
    $result = ["role"=>$session_role, "action"=>"user", "userId"=>$user_id_session, "userInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}



function user_search( $group_id,  $lastname, $firstname, $middlename, $organization_id,  $subdivision, $position, $cart_id,  $email, $login) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    if($lastname=='' &&  $email=='' &&  $login=='' ){
	$result = ["status"=>0, "error"=>'',  "role"=>$session_role, "action"=>"user_serch",  "userId"=>$user_id_session, "userInfo"=>["userId"=>0]];
	echo json_encode($result, JSON_UNESCAPED_UNICODE);
        return;
    }

    $rc = ["userId"=>0];
    if($organization_id > 0) {
	$stmt = $dbh->prepare('SELECT  `a_users`.`user_id`,  `lastname`, `firstname`, `middlename`, `email`, `login`, `password`,  `organization_id`, `position_id`, `subdivision`, `cart_id`  FROM `a_users`    LEFT JOIN `a_groups_users` USING(`user_id`) LEFT JOIN `a_positions` USING(`position_id`)  WHERE (`a_groups_users`.`group_id` IS NULL or `a_groups_users`.`group_id` != ?) and `lastname` LIKE ? and `firstname` LIKE ? and `middlename` LIKE ?   and `organization_id`=?  and  `subdivision` LIKE ?  and `a_positions`.`name` LIKE ?  and `cart_id`  LIKE ?    LIMIT 2');
	$stmt->execute([$group_id, "$lastname%", "$firstname%", "$middlename%", $organization_id, "$subdivision%", "$position%",  "$cart_id%" ]);
	//$stmt = $dbh->prepare('SELECT  `a_users`.`user_id`,  `lastname`, `firstname`, `middlename`, `email`, `login`, `password`,  `organization_id`, `position_id`, `subdivision`, `date_of_birth`  FROM `a_users`    LEFT JOIN `a_groups_users` USING(`user_id`)   WHERE (`a_groups_users`.`group_id` IS NULL or `a_groups_users`.`group_id` != ?) and `lastname` LIKE ? and `firstname` LIKE ? and `middlename` LIKE ?   and `organization_id`=?  and  `subdivision` LIKE ? and `date_of_birth`  LIKE ?    LIMIT 2');
	//$stmt->execute([$group_id, "$lastname%", "$firstname%", "$middlename%", $organization_id, "$subdivision%",  "$date_of_birth%" ]);
    }
    else {
	//$stmt = $dbh->prepare('SELECT  `a_users`.`user_id`,  `lastname`, `firstname`, `middlename`, `email`, `login`, `password`,  `organization_id`, `position_id`, `subdivision`, `date_of_birth`  FROM `a_users`    LEFT JOIN `a_groups_users` USING(`user_id`)   WHERE (`a_groups_users`.`group_id` IS NULL or `a_groups_users`.`group_id` != ?) and `lastname` LIKE ? and `firstname` LIKE ? and `middlename`  LIKE ?   and `date_of_birth` LIKE ? LIMIT 2');
	//$stmt->execute([$group_id, "$lastname%", "$firstname%", "$middlename%",  "$date_of_birth%" ]);
	$stmt = $dbh->prepare('SELECT  `a_users`.`user_id`,  `lastname`, `firstname`, `middlename`, `email`, `login`, `password`,  `organization_id`, `position_id`, `subdivision`, `cart_id`  FROM `a_users`    LEFT JOIN `a_groups_users` USING(`user_id`)   WHERE (`a_groups_users`.`group_id` IS NULL or `a_groups_users`.`group_id` != ?) and `lastname` LIKE ? and `firstname` LIKE ? and `middlename`  LIKE ?  LIMIT 2');
	$stmt->execute([$group_id, "$lastname%", "$firstname%", "$middlename%" ]);
    }
    if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $organization_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_organizations`  WHERE `organization_id`=? ');
    	    $stmt2->execute([$row->organization_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$organization_name = $row2->name;
	    }
	    $position_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_positions`  WHERE `position_id`=? ');
    	    $stmt2->execute([$row->position_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$position_name = $row2->name;
	    }

	    $rc =  ["userId"=>$row->user_id, "lastname"=>$row->lastname, "firstname"=>$row->firstname, "middlename"=>$row->middlename, "email_lms"=>$row->email, "login"=>$row->login,  "password"=>$row->password, "organization_id"=>$row->organization_id, "position_id"=>$row->position_id, "organization"=>$organization_name, "position"=>$position_name, "subdivision"=>$row->subdivision, "cart_id"=>$row->cart_id ];
    }
    $is_single = 1;
    if($row = $stmt->fetch(PDO::FETCH_OBJ)) {
	if($row->user_id > 0)
	    $is_single = 0;
    }

    $result = ["status"=>0, "error"=>'', "role"=>$session_role, "action"=>"user_serch", "userId"=>$user_id_session, "userInfo"=>$rc, "userSingle"=>$is_single ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}



function user_report($user_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    $rc =  [];
    $rc2 =  [];
    if($user_id >0 ) {
	$stmt = $dbh->prepare('SELECT `num`, `a_cache_course`.`name`, `a_reports`.`course_id`, `date`, `result`  FROM `a_reports` LEFT JOIN  `a_cache_course` USING(`course_id`)  WHERE `user_id`=?');
	$stmt->execute([$user_id]);
	while($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $rc[] =  ["num"=>$row->num, "course"=>$row->name, "course_id"=>$row->course_id, "date"=>$row->date, "result"=>$row->result ];
	}
//	$stmt = $dbh->prepare('SELECT  `a_cache_course`.`name`, `a_progress`.`course_id`,   `grade`, `modules`, `grade_test`, `modules_test`, `a_date`   FROM `a_progress`  LEFT JOIN  `a_cache_course` USING(`course_id`)   WHERE `user_id`=? ');
//        $stmt->execute([$user_id]);
	$stmt = $dbh->prepare('SELECT   `date_begin`, `a_groups_users`.`group_id`, `a_groups`.`course_id`, `a_cache_course`.`name`    FROM `a_groups_users` LEFT JOIN  `a_groups` USING(`group_id`) LEFT JOIN  `a_cache_course` USING(`course_id`)  WHERE  `a_groups_users`.`user_id`=? ');
        $stmt->execute([$user_id]);
	while($row = $stmt->fetch(PDO::FETCH_OBJ)) {
	    $stmt2 = $dbh->prepare('SELECT   `result` FROM `a_reports`     WHERE `a_reports`.`course_id`=? AND `user_id`=?');
	    $stmt2->execute([$row->course_id, $user_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {  
		continue;
	    }
	    $rc2[] =  ["num"=>'', "course"=>$row->name, "course_id"=>$row->course_id, "date"=>$row->date_begin, "result"=>'' ];
	}
    }
    $result = ["role"=>$session_role, "action"=>"user_report", "userId"=>$user_id_session, "userReport"=>$rc, "userProgress"=>$rc2 ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}






function user_save($user_id, $email_lms, $login, $lastname, $firstname, $middlename,  $password, $organization_id, $position_id_arg, $position_name, $subdivision, $date_of_birth, $group_id ) {
    global $api_arg, $user_id_session, $session_role, $EmailDomain, $AccountPrefix, $dbh;

    if($lastname=='' ||  $firstname==''){
	$result = ["status"=>1, "error"=>'Не все обязательные поля заполнены',  "role"=>$session_role, "action"=>"user_save",  "userId"=>$user_id_session, "userInfo"=>["userId"=>0]];
	echo json_encode($result, JSON_UNESCAPED_UNICODE);
        return;
    }
    
    $position_id = 0;
    if(trim($position_name) != ''){
	$count_p = 0;
	$stmt = $dbh->prepare("select `position_id` FROM  `a_positions`  WHERE `name`=?   ");
        $stmt->execute([trim($position_name)]);
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {
	    $count_p = 1;
	    $position_id = $row->position_id;
	}
	if($count_p == 0 && trim($position_name) != '') {
	    $stmt = $dbh->prepare("INSERT INTO `a_positions`(`name`) VALUES(?)");
    	    $stmt->execute([trim($position_name)]);
	    $position_id = $dbh->lastInsertId(); 
	}

    }

    if($user_id>0){
        $stmt = $dbh->prepare('UPDATE `a_users` SET `lastname`=?, `firstname`=?,  `middlename`=?,  `organization_id`=?,  `subdivision`=?,  `position_id`=?, `date_of_birth`=?   WHERE `user_id`=?');
        $stmt->execute([$lastname, $firstname, $middlename, $organization_id, $subdivision, $position_id, $date_of_birth,     $user_id ]);
	if( $password !=' ' ){
    	    $stmt = $dbh->prepare('UPDATE `a_users` SET `password`=?  WHERE `user_id`=?');
    	    $stmt->execute([$password,     $user_id ]);
	}
        $p_user_id = $user_id; 
    }
    else {
	$exist_user_id = 0;
	if($organization_id > 0) {
	    $stmt = $dbh->prepare('SELECT  `user_id`   FROM `a_users` WHERE  `lastname` LIKE ? and `firstname` LIKE ? and  `middlename` LIKE ?   and `organization_id`=? and `position_id`=? and `subdivision` LIKE ? and `date_of_birth` LIKE ?  LIMIT 2');
	    $stmt->execute(["$lastname%", "$firstname%", "$middlename%", $organization_id, $position_id, $subdivision, $date_of_birth]);
	}
	else {
	    $stmt = $dbh->prepare('SELECT  `user_id`  FROM `a_users` WHERE  `lastname` LIKE ? and `firstname` LIKE ? and  `middlename` LIKE ? and `date_of_birth` LIKE ?  LIMIT 2');
	    $stmt->execute(["$lastname%", "$firstname%", "$middlename%", $date_of_birth]);
	}
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $exist_user_id = $row->user_id;
	}
	if( $exist_user_id > 0 ){
	    $result = ["status"=>1, "error"=>'Учетная запись уже существует',  "role"=>$session_role, "action"=>"user_save",  "userId"=>$user_id_session, "userInfo"=>["userId"=>$exist_user_id ] ];
	    echo json_encode($result, JSON_UNESCAPED_UNICODE);
	    return;
	} 

        $stmt = $dbh->prepare('INSERT INTO `a_users`(`lastname`, `firstname`,  `middlename`,  `organization_id`,  `position_id`, `subdivision`, `date_of_birth`) VALUES ( ?, ?, ?, ?, ?, ?, ?)');
	$stmt->execute([$lastname, $firstname, $middlename, $organization_id, $position_id, $subdivision, $date_of_birth]);
	$p_user_id = $dbh->lastInsertId(); 
	if($p_user_id<=0){
	    $result = ["status"=>2, "error"=>'Ошибка DB',  "role"=>$session_role, "action"=>"user_save",  "userId"=>$user_id_session, "userInfo"=>["userId"=>0]];
	    echo json_encode($result, JSON_UNESCAPED_UNICODE);
    	    return;
	}

	$passwd_chars = 'abcdefghijkmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ23456789';
	$login = $AccountPrefix . str_pad("$p_user_id", 5, '0', STR_PAD_LEFT); 
	$email_lms = $login . $EmailDomain;
	$shfl = str_shuffle($passwd_chars);
	$password = substr($shfl,0,8);
 
        $stmt2 = $dbh->prepare('UPDATE `a_users` SET `email`=?, `login`=?, `password`=?  WHERE `user_id`=?');
        $stmt2->execute([$email_lms, $login, $password,  $p_user_id ]);

        if($group_id >0) {
    	    $stmt = $dbh->prepare('INSERT INTO `a_groups_users`(`group_id`,  `user_id`) VALUES ( ?, ?)');
	    $stmt->execute([$group_id,  $p_user_id]);
	}
    }

    //$stmt = $dbh->prepare('REPLACE INTO `users`(`user_id`, `name`, `fullname`) VALUES ( ?, ?, ?)');
        //$stmt = $dbh->prepare('INSERT INTO `users`(`user_id`,`name`, `fullname`) VALUES ( ?, ?)  ON DUPLICATE KEY UPDATE `fullname` = VALUES(`fullname`), `name` = VALUES(`name`)');



    
    /* if($p_user_id>0 && $passwd1!='' && $passwd2!=''){
    $rc2=1;
    if($passwd1 == $passwd2){
        $stmt2 = $dbh->prepare('UPDATE `users` SET `password`=?  WHERE `user_id`=?');
        $stmt2->execute( [md5($passwd1), $p_user_id ]);
        if($stmt2) 
	$rc2=0;
    else if($rc2) {
            $rc_list = [ "status"=>"7", "error"=>'error Не совпадает Пароль и Пароль повторно ' ];
    }
    }*/ 


    /*if(!$stmt) {
            $rc_list = [ "status"=>"4", "error"=>'error 2: '. $dbh->errorInfo()[2] ];
    }
    }
    else {
            $rc_list = [ "status"=>"0", "error"=> '' ];
    }*/

    $result = ["status"=>0, "error"=>'',  "role"=>$session_role, "action"=>"user_save",  "userId"=>$user_id_session, "userInfo"=>["userId"=>$p_user_id] ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}




function user_link($group_id,  $user_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    if($user_id>0 && $group_id>0) {
        $stmt = $dbh->prepare('DELETE FROM `a_groups_users` WHERE `group_id`=?  AND  `user_id`=? ');
	    $stmt->execute([$group_id,  $user_id ]);

        $stmt = $dbh->prepare('INSERT INTO `a_groups_users`(`group_id`,  `user_id`) VALUES ( ?, ?)');
	    $stmt->execute([$group_id,  $user_id ]);
    }


    $result = ["status"=>0, "error"=>'',  "role"=>$session_role, "action"=>"user_link",  "userId"=>$user_id_session ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}



function user_del($user_id) {
    global $api_arg, $user_id_session, $session_role, $customer, $dbh;

    $status = "0";
    $error = '';

    if($user_id >0) {
        $stmt = $dbh->prepare('DELETE FROM `a_groups_users` WHERE  `user_id`=? ');
	$stmt->execute([$user_id ]);

	$stmt = $dbh->prepare('DELETE FROM `a_users`  WHERE `user_id`=?');
	$stmt->execute([$user_id]);

	if(!$stmt) {
            $status = "4";
	    $error = 'error 2: '. $dbh->errorInfo()[2];
	}
    }

    $result = ["status"=>$status, "error"=>$error, "role"=>$session_role, "action"=>"user_del", "customerId"=>$customer, "userId"=>$user_id_session];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}


function group_items($group_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $users_list = [];
    //$rc_list[] = ["userId"=>0, "login"=>'', "name"=>'', "fullname"=>''];


	$stmt = $dbh->prepare('SELECT `a_users`.`user_id`, `login`, `lastname`, `firstname`, `middlename`, `email`, `organization_id`, `position_id`, `subdivision`, `date_of_birth`  FROM `a_users`  LEFT JOIN `a_groups_users` USING(`user_id`)  WHERE `group_id`=?   ORDER BY `lastname`');
	$stmt->execute([$group_id]);
	while($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $organization_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_organizations`  WHERE `organization_id`=? ');
    	    $stmt2->execute([$row->organization_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$organization_name = $row2->name;
	    }
	    $position_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_positions`  WHERE `position_id`=? ');
    	    $stmt2->execute([$row->position_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$position_name = $row2->name;
	    }

	    $users_list[] =  ["userId"=>$row->user_id, "login"=>$row->login, "lastname"=>$row->lastname, "firstname"=>$row->firstname, "middlename"=>$row->middlename, "organization"=>$organization_name, "position"=>$position_name, "subdivision"=>$row->subdivision, "date_of_birth"=>$row->date_of_birth ];
    }
    //}
    //$result = ["role"=>$session_role, "action"=>"users_list", "userId"=>$user_id_session, "result"=>$rc_list];
    $result = ["role"=>$session_role, "action"=>"group_items",  "list"=>$users_list,  "search"=>$is_search];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}


function group_item_del($group_id, $user_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    if($group_id >0 ) {
	$stmt = $dbh->prepare('DELETE FROM  `a_groups_users`   WHERE `group_id`=? AND `user_id`=? ');
	$stmt->execute([$group_id, $user_id]);
    }

    $result = ["status"=>0, "error"=>'', "role"=>$session_role, "action"=>"group_item_del" ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function group_del($group_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    if($group_id >0 ) {
	$stmt = $dbh->prepare('DELETE FROM  `a_groups_users`   WHERE `group_id`=?  ');
	$stmt->execute([$group_id]);

	$stmt = $dbh->prepare('DELETE FROM  `a_groups`   WHERE `group_id`=?  ');
	$stmt->execute([$group_id]);
    }

    $result = ["status"=>0, "error"=>'', "role"=>$session_role, "action"=>"group_del" ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}



function groups_list($is_search, $group) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    $g_list = [];

    if($is_search >0){
	$stmt = $dbh->prepare('SELECT `group_id`,  `name`  FROM `a_groups` WHERE `name` LIKE ?   ORDER BY `name`  LIMIT 200');
        $stmt->execute(["$group%"]);
    }
    else {
	$stmt = $dbh->query('SELECT `group_id`,  `name`  FROM `a_groups`    ORDER BY `group_id` DESC LIMIT 200');
    }
    while($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	$group_count = 0;
	$stmt2 = $dbh->prepare('SELECT count(*) as `count` FROM  `a_groups_users`   WHERE `group_id`=? AND `user_id`>0 ');
	$stmt2->execute([$row->group_id]);
	if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {  
	    $group_count = $row2->count;
	}
	$g_list[] =  ["groupId"=>$row->group_id,  "name"=>$row->name, "count"=>$group_count  ];
    }

    $result = ["role"=>$session_role, "action"=>"group_list",  "list"=>$g_list,  "search"=>$is_search];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}


function group_detalies($group_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $rc =  ["group_id"=>0,  "name"=>''  ];
    if($group_id >0 ) {
	$stmt = $dbh->prepare('SELECT  `group_id`,  `name`, `course_id`, `date`, `date_begin`, `date_end`  FROM `a_groups`   WHERE `group_id`=?');
	$stmt->execute([$group_id]);
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $rc =  ["group_id"=>$row->group_id, "name"=>$row->name,  "courseId"=>$row->course_id, "date"=>$row->date, "date2"=>$row->date_end  ];
	}
    }
    $result = ["role"=>$session_role, "action"=>"group_detalies", "userId"=>$user_id_session, "groupInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function group_save($group_id, $name, $course_id, $date_g, $date_2 ) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $rc =  ["group_id"=>0  ];
    if($group_id >0 ) {
        $stmt = $dbh->prepare('UPDATE `a_groups` SET  `name`=?, `course_id`=?, `date`=?, `date_begin`=?, `date_end`=?  WHERE `group_id`=?');
        $stmt->execute([ $name, $course_id, $date_g,  $date_g, $date_2,  $group_id ]);
        $p_group_id = $group_id; 
    }
    else {
        $stmt = $dbh->prepare('INSERT INTO `a_groups`(`name`, `course_id`, `date`, `date_begin`, `date_end`) VALUES ( ?, ?, ?, ?, ?)');
	    $stmt->execute([$name, $course_id, $date_g,  $date_g, $date_2 ]);
	    $p_group_id = $dbh->lastInsertId(); 
    }

    $rc =  ["group_id"=>$p_group_id  ];
    $result = ["status"=>"0", "error"=>'', "role"=>$session_role, "action"=>"group_save", "userId"=>$user_id_session, "groupInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}


function group_clone($group_id, $name, $course_id, $date_g ) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $rc =  ["group_id"=>0  ];
    if($group_id >0 ) {
        $stmt = $dbh->prepare('INSERT INTO `a_groups`(`name`, `course_id`, `date`) VALUES ( ?, ?, ?)');
	    $stmt->execute([$name, $course_id, $date_g ]);
	    $p_group_id = $dbh->lastInsertId(); 
    }

    if($p_group_id > 0 ) {
	    $stmt = $dbh->prepare('SELECT `user_id`  FROM  `a_groups_users`   WHERE `group_id`=?');
	    $stmt->execute([$group_id]);
    	while($row = $stmt->fetch(PDO::FETCH_OBJ)) { 
    	    $user_id =  $row->user_id; 
            $stmt2 = $dbh->prepare('INSERT INTO `a_groups_users`(`group_id`,  `user_id`) VALUES ( ?, ?)');
	        $stmt2->execute([$p_group_id,  $user_id ]);
	       
        }
    }    

    $rc =  ["group_id"=>$p_group_id  ];
    $result = ["status"=>"0", "error"=>'', "role"=>$session_role, "action"=>"group_clone", "userId"=>$user_id_session, "groupInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}


function group_report($group_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    $course_id = 0;
    $rc = [];
    $list = [];
    if($group_id >0 ) {
	$stmt = $dbh->prepare('SELECT  `course_id`  FROM `a_groups`   WHERE `group_id`=?');
	$stmt->execute([$group_id]);
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $course_id = $row->course_id;
	}
     }
     if($group_id >0 &&  $course_id >0) { 
	$stmt = $dbh->prepare('SELECT `user_id`  FROM `a_groups_users` WHERE `group_id`=?');
	$stmt->execute([$group_id]);
	while($row = $stmt->fetch(PDO::FETCH_OBJ)) {
	    $result = '';
	    $rc1 = [];
	    $user_id = $row->user_id;  
	    $stmt1 = $dbh->prepare('SELECT `num`, `course`, `date`, `result`  FROM `a_reports`   WHERE `user_id`=? AND `course_id`=?' );
	    $stmt1->execute([$user_id, $course_id]);
	    if($row1 = $stmt1->fetch(PDO::FETCH_OBJ)) {  
		$result = $row1->result;
		$rc1[] =  ["num"=>$row1->num,  "date"=>$row1->date, "result"=>$row1->result, "course"=>$row1->course, "progress"=>'', "progress_test"=>''  ];
	    }
            if($result == '' ){
                $progress = '0';
		$stmt2 = $dbh->prepare('SELECT  `grade`, `modules`, `grade_test`, `modules_test`   FROM `a_progress`  WHERE `user_id`=? AND `course_id`=? ');
                $stmt2->execute([$user_id, $course_id]);
		if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		    if($row2->modules>0)
			$progress = intval($row2->grade / $row2->modules * 100);
                    if($progress > 100)
			$progress = 100;

		    if($row2->modules_test>0)
			$progress_test = intval($row2->grade_test / $row2->modules_test * 100);
                    if($progress_test > 100)
			$progress_test = 100;
		}
		$rc1[] =  ["num"=>'',  "date"=>'', "result"=>'', "course"=>'', "progress"=>$progress, "progress_test"=>$progress_test  ];
            }

	    $list[]  =  ["userId"=>$user_id,  "result"=>$rc1 ];
	    //array_push($list,  [$user_id=>$rc1]) ;
	}
    }
    $rc =  ["group_id"=>$group_id,  "course_id"=>$course_id,  "list"=>$list ];
    $result = ["role"=>$session_role, "action"=>"group_report", "userId"=>$user_id_session, "groupReport"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}







function positions_list($is_search, $position) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $p_list = [];
    //$rc_list[] = ["userId"=>0, "login"=>'', "name"=>'', "fullname"=>''];

    //if($session_role) {
    if($is_search >0){
	$stmt = $dbh->prepare('SELECT `position_id`,  `name`  FROM `a_positions` WHERE `name` LIKE ?   ORDER BY `name`');
        $stmt->execute(["$position%"]);
    }
    else {
	$stmt = $dbh->query('SELECT `position_id`,  `name`  FROM `a_positions`    ORDER BY `name`');
    }
    while($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $p_list[] =  ["positionId"=>$row->position_id,  "name"=>$row->name  ];
    }
    //}
    $result = ["role"=>$session_role, "action"=>"positions_list",  "list"=>$p_list,  "search"=>$is_search];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}


function position_detalies($position_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $rc =  ["position_id"=>0,  "name"=>''  ];
    if($position_id >0 ) {
	$stmt = $dbh->prepare('SELECT  `position_id`,  `name`  FROM `a_positions`   WHERE `position_id`=?');
	$stmt->execute([$position_id]);
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $rc =  ["position_id"=>$row->position_id, "name"=>$row->name  ];
	}
    }
    $result = ["role"=>$session_role, "action"=>"position_detalies", "userId"=>$user_id_session, "positionInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function position_save($position_id, $name) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $rc =  ["position_id"=>0  ];
    if($position_id >0 ) {
        $stmt = $dbh->prepare('UPDATE `a_positions` SET  `name`=?  WHERE `position_id`=?');
        $stmt->execute([ $name, $position_id ]);
        $p_position_id = $position_id; 
    }
    else {
        $stmt = $dbh->prepare('INSERT INTO `a_positions`(`name`) VALUES ( ?)');
	$stmt->execute([$name ]);
	$p_position_id = $dbh->lastInsertId(); 
    }

    $rc =  ["position_id"=>$p_position_id  ];
    $result = ["status"=>"0", "error"=>'', "role"=>$session_role, "action"=>"position_save", "userId"=>$user_id_session, "positionInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function position_del($positionid) {
    global $api_arg, $user_id_session, $session_role, $customer, $dbh;

    $status = "0";
    $error = '';

    if($positionid >0) {
	$stmt = $dbh->prepare('DELETE FROM `a_positions`  WHERE `position_id`=?');
	$stmt->execute([$positionid]);

	if(!$stmt) {
            $status = "4";
	    $error = 'error 2: '. $dbh->errorInfo()[2];
	}
    }

    $result = ["status"=>$status, "error"=>$error, "role"=>$session_role, "action"=>"position_del", "customerId"=>$customer, "userId"=>$user_id_session];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}





function organizations_list($is_search, $organization) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $p_list = [];
    //$rc_list[] = ["userId"=>0, "login"=>'', "name"=>'', "fullname"=>''];

    //if($session_role) {
    if($is_search >0){
	$stmt = $dbh->prepare('SELECT `organization_id`,  `name`  FROM `a_organizations` WHERE `name` LIKE ?   ORDER BY `name`');
        $stmt->execute(["$organization%"]);
    }
    else {
	$stmt = $dbh->query('SELECT `organization_id`,  `name`  FROM `a_organizations`    ORDER BY `name`');
    }
    while($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $p_list[] =  ["organizationId"=>$row->organization_id,  "name"=>$row->name  ];
    }
    //}
    $result = ["role"=>$session_role, "action"=>"organizations_list",  "list"=>$p_list,  "search"=>$is_search];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function organization_detalies($organization_id) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $rc =  ["organization_id"=>0,  "name"=>''  ];
    if($organization_id >0 ) {
	$stmt = $dbh->prepare('SELECT  `organization_id`,  `name`  FROM `a_organizations`   WHERE `organization_id`=?');
	$stmt->execute([$organization_id]);
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $rc =  ["organization_id"=>$row->organization_id, "name"=>$row->name  ];
	}
    }
    $result = ["role"=>$session_role, "action"=>"organization_detalies", "userId"=>$user_id_session, "organizationInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function organization_save($organization_id, $name) {
    global $api_arg, $user_id_session, $session_role,  $dbh;


    $rc =  ["organization_id"=>0  ];
    if($organization_id >0 ) {
        $stmt = $dbh->prepare('UPDATE `a_organizations` SET  `name`=?  WHERE `organization_id`=?');
        $stmt->execute([ $name, $organization_id ]);
        $p_organization_id = $organization_id; 
    }
    else {
        $stmt = $dbh->prepare('INSERT INTO `a_organizations`(`name`) VALUES ( ?)');
	$stmt->execute([$name ]);
	$p_organization_id = $dbh->lastInsertId(); 
    }

    $rc =  ["organization_id"=>$p_organization_id  ];
    $result = ["status"=>"0", "error"=>'', "role"=>$session_role, "action"=>"organization_save", "userId"=>$user_id_session, "organizationInfo"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function organization_del($organizationid) {
    global $api_arg, $user_id_session, $session_role, $customer, $dbh;

    $status = "0";
    $error = '';

    if($organizationid >0) {
	$stmt = $dbh->prepare('DELETE FROM `a_organizations`  WHERE `organization_id`=?');
	$stmt->execute([$organizationid]);

	if(!$stmt) {
            $status = "4";
	    $error = 'error 2: '. $dbh->errorInfo()[2];
	}
    }

    $result = ["status"=>$status, "error"=>$error, "role"=>$session_role, "action"=>"organization_del", "customerId"=>$customer, "userId"=>$user_id_session];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}




function course_report($course_id , $date1, $date2 ) {
    global $api_arg, $user_id_session, $session_role,  $dbh;

    $course = '';
    $rc =  [];
    if($course_id >0 ) {
	$stmt = $dbh->prepare('SELECT `course`   FROM `a_reports`  WHERE `course_id`=?   LIMIT 1 ');
	$stmt->execute([$course_id]);
	if($row = $stmt->fetch(PDO::FETCH_OBJ)) {  
	    $course_name =  $row->course;
	}

	$date_filter = '';
        if( $date1!='' )
           $date_filter = " AND `a_date`>='" .$date1. "' ";
        if( $date2!='' )
           $date_filter = $date_filter. " AND `a_date`<='" .$date2. "' ";

	$stmt = $dbh->prepare('SELECT `a_reports`.`user_id`, `num`,   `date`, `result`, `lastname`, `firstname`, `middlename`, `email`, `organization_id`, `position_id`, `subdivision`   FROM `a_reports` LEFT JOIN  `a_users` USING(`user_id`)  WHERE `course_id`=? '.$date_filter.'  ORDER BY `lastname`  LIMIT 500 ');
	$stmt->execute([$course_id]);
//file_put_contents("/var/www/aisbsk/moodle/lst.txt", $date_filter);
	while($row = $stmt->fetch(PDO::FETCH_OBJ)) {  

	    $organization_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_organizations`  WHERE `organization_id`=? ');
    	    $stmt2->execute([$row->organization_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$organization_name = $row2->name;
	    }
	    $position_name = '';
	    $stmt2 = $dbh->prepare('SELECT  `name`  FROM `a_positions`  WHERE `position_id`=? ');
    	    $stmt2->execute([$row->position_id]);
	    if($row2 = $stmt2->fetch(PDO::FETCH_OBJ)) {
		$position_name = $row2->name;
	    }

	    $rc[] =  ["userId"=>$row->user_id, "num"=>$row->num, "date"=>$row->date, "result"=>$row->result, "lastname"=>$row->lastname, "firstname"=>$row->firstname, "middlename"=>$row->middlename, "organization"=>$organization_name, "position"=>$position_name  ];
	}
    }
    $result = ["status"=>"0", "error"=>'', "role"=>$session_role, "action"=>"course_report", "userId"=>$user_id_session,  "course_id"=>$course_id, "course"=>$course_name, "userReport"=>$rc ];
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}



function course_report2($course_id , $date1, $date2, $type_search, $completed, $course_check ) {
     
    $result = core_course_report2($course_id , $date1, $date2, $type_search, $completed, $course_check );
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

function res_report( $date1, $date2, $type_search, $completed ) {
     
    $result = core_res_report( $date1, $date2 );
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}


if($api_function=='users_list'){
    users_list($api_arg["search"], $api_arg["lastname"], $api_arg["firstname"], $api_arg["middlename"], intval($api_arg["organization"]), $api_arg["page"] );
}
else if($api_function=='user_detalies'  ){
    user_detalies(intval($api_arg["userId"]));
}
else if($api_function=='user_view'  ){
    user_detalies(intval($api_arg["cartId"]));
}
else if($api_function=='user_save' ){
    user_save(intval($api_arg["userId"]), $api_arg["email_lms"],  $api_arg["login"], $api_arg["lastname"], $api_arg["firstname"], $api_arg["middlename"],  $api_arg["password"], $api_arg["organization_id"], $api_arg["position_id"], $api_arg["position_name"], $api_arg["subdivision"], $api_arg["date_of_birth"], intval($api_arg["groupId"])  );
}
else if($api_function=='user_del' ){
    user_del( intval($api_arg["userId"]) );
}
else if($api_function=='user_search' ){
    user_search( intval($api_arg["groupId"]),  $api_arg["lastname"], $api_arg["firstname"], $api_arg["middlename"],  intval($api_arg["organizationId"]),  $api_arg["subdivision"], $api_arg["$position"], $api_arg["cart_id"],  $api_arg["email"],  $api_arg["login"] );
}
else if($api_function=='user_link' ){
    user_link(intval($api_arg["groupId"]), intval($api_arg["userId"]));
}
else if($api_function=='user_report'){
    user_report( intval($api_arg["userId"]) );
}
else if($api_function=='course_report'){
    course_report( intval($api_arg["courseId"]), $api_arg["date1"], $api_arg["date2"] );
}
else if($api_function=='course_report2'){
    course_report2( intval($api_arg["courseId"]), $api_arg["date1"], $api_arg["date2"], $api_arg["type_search"], $api_arg["completed"], $api_arg["course_check"]);
}
else if($api_function=='res_report'){
    res_report( $api_arg["date1"], $api_arg["date2"], $api_arg["type_search"], $api_arg["completed"] );
}



else if($api_function=='group_items'){
    group_items(intval($api_arg["groupId"]) );
}
else if($api_function=='group_item_del'){
    group_item_del(intval($api_arg["groupId"]), intval($api_arg["userId"]) );
}
else if($api_function=='group_del'){
    group_del(intval($api_arg["groupId"]) );
}
else if($api_function=='groups_list'){
    groups_list($api_arg["search"], $api_arg["name"]);
}
else if($api_function=='group_detalies'){
    group_detalies(intval($api_arg["groupId"]));
}
else if($api_function=='group_save'){
    group_save(intval($api_arg["groupId"]), $api_arg["name"], intval($api_arg["courseId"]), $api_arg["date"], $api_arg["date2"] );
}
else if($api_function=='group_clone'){
    group_clone(intval($api_arg["groupId"]), $api_arg["name"], intval($api_arg["courseId"]), $api_arg["date"] );
}
else if($api_function=='group_report'){
    group_report( intval($api_arg["groupId"]) );
}


else if($api_function=='positions'){
    positions_list($api_arg["search"], $api_arg["name"]);
}
else if($api_function=='position_detalies'){
    position_detalies(intval($api_arg["positionId"]));
}
else if($api_function=='position_save'){
    position_save(intval($api_arg["positionId"]), $api_arg["name"]);
}
else if($api_function=='position_del'){
    position_del(intval($api_arg["positionId"]));
}


else if($api_function=='organizations'){
    organizations_list($api_arg["search"], $api_arg["name"]);
}
else if($api_function=='organization_detalies'){
    organization_detalies(intval($api_arg["organizationId"]));
}
else if($api_function=='organization_save'){
    organization_save(intval($api_arg["organizationId"]), $api_arg["name"]);
}
else if($api_function=='organization_del'){
    organization_del(intval($api_arg["organizationId"]));
}

else {
    $result = array('POST'=>$_POST, 'GET'=>$_GET, 'SERVER'=>$_SERVER, 'JSON'=>$_JSON);
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}

?>
