/**
 * Controls the popover region element.
 *
 * See template: core/popover_region
 *
 * @module     core/popover_region_controller
 * @copyright  2015 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.2
 */
define("core/popover_region_controller",["jquery","core/str","core/custom_interaction_events"],(function($,str,customEvents){var SELECTORS_CONTENT=".popover-region-content",SELECTORS_CONTENT_CONTAINER=".popover-region-content-container",SELECTORS_MENU_CONTAINER=".popover-region-container",SELECTORS_MENU_TOGGLE=".popover-region-toggle",SELECTORS_CAN_RECEIVE_FOCUS='input:not([type="hidden"]), a[href], button, textarea, select, [tabindex]',PopoverRegionController=function(element){this.root=$(element),this.content=this.root.find(SELECTORS_CONTENT),this.contentContainer=this.root.find(SELECTORS_CONTENT_CONTAINER),this.menuContainer=this.root.find(SELECTORS_MENU_CONTAINER),this.menuToggle=this.root.find(SELECTORS_MENU_TOGGLE),this.isLoading=!1,this.promises={closeHandlers:$.Deferred(),navigationHandlers:$.Deferred()},this.registerBaseEventListeners()};return PopoverRegionController.prototype.events=function(){return{menuOpened:"popoverregion:menuopened",menuClosed:"popoverregion:menuclosed",startLoading:"popoverregion:startLoading",stopLoading:"popoverregion:stopLoading"}},PopoverRegionController.prototype.getContentContainer=function(){return this.contentContainer},PopoverRegionController.prototype.getContent=function(){return this.content},PopoverRegionController.prototype.isMenuOpen=function(){return!this.root.hasClass("collapsed")},PopoverRegionController.prototype.toggleMenu=function(){this.isMenuOpen()?this.closeMenu():this.openMenu()},PopoverRegionController.prototype.closeMenu=function(){this.isMenuOpen()&&(this.root.addClass("collapsed"),this.menuContainer.attr("aria-expanded","false"),this.menuContainer.attr("aria-hidden","true"),this.updateButtonAriaLabel(),this.updateFocusItemTabIndex(),this.root.trigger(this.events().menuClosed))},PopoverRegionController.prototype.openMenu=function(){this.isMenuOpen()||(this.root.removeClass("collapsed"),this.menuContainer.attr("aria-expanded","true"),this.menuContainer.attr("aria-hidden","false"),this.updateButtonAriaLabel(),this.updateFocusItemTabIndex(),this.promises.closeHandlers.resolve(),this.promises.navigationHandlers.resolve(),this.root.trigger(this.events().menuOpened))},PopoverRegionController.prototype.updateButtonAriaLabel=function(){this.isMenuOpen()?str.get_string("hidepopoverwindow").done(function(string){this.menuToggle.attr("aria-label",string)}.bind(this)):str.get_string("showpopoverwindow").done(function(string){this.menuToggle.attr("aria-label",string)}.bind(this))},PopoverRegionController.prototype.startLoading=function(){this.isLoading=!0,this.getContentContainer().addClass("loading"),this.getContentContainer().attr("aria-busy","true"),this.root.trigger(this.events().startLoading)},PopoverRegionController.prototype.stopLoading=function(){this.isLoading=!1,this.getContentContainer().removeClass("loading"),this.getContentContainer().attr("aria-busy","false"),this.root.trigger(this.events().stopLoading)},PopoverRegionController.prototype.focusMenuToggle=function(){this.menuToggle.focus()},PopoverRegionController.prototype.contentItemHasFocus=function(){return this.getContentItemWithFocus().length>0},PopoverRegionController.prototype.getContentItemWithFocus=function(){var currentFocus=$(document.activeElement),items=this.getContent().children(),currentItem=items.filter(currentFocus);return currentItem.length||(currentItem=items.has(currentFocus)),currentItem},PopoverRegionController.prototype.focusContentItem=function(item){item.is(SELECTORS_CAN_RECEIVE_FOCUS)?item.focus():item.find(SELECTORS_CAN_RECEIVE_FOCUS).first().focus()},PopoverRegionController.prototype.focusFirstContentItem=function(){this.focusContentItem(this.getContent().children().first())},PopoverRegionController.prototype.focusLastContentItem=function(){this.focusContentItem(this.getContent().children().last())},PopoverRegionController.prototype.focusNextContentItem=function(){var currentItem=this.getContentItemWithFocus();currentItem.length&&currentItem.next()&&this.focusContentItem(currentItem.next())},PopoverRegionController.prototype.focusPreviousContentItem=function(){var currentItem=this.getContentItemWithFocus();currentItem.length&&currentItem.prev()&&this.focusContentItem(currentItem.prev())},PopoverRegionController.prototype.registerBaseEventListeners=function(){customEvents.define(this.root,[customEvents.events.activate,customEvents.events.escape]),this.root.on(customEvents.events.activate,SELECTORS_MENU_TOGGLE,function(){this.toggleMenu()}.bind(this)),this.promises.closeHandlers.done(function(){this.root.on(customEvents.events.escape,function(){this.closeMenu(),this.focusMenuToggle()}.bind(this)),$("html").click(function(e){var target=$(e.target);this.root.is(target)||this.root.has(target).length||this.closeMenu()}.bind(this)),customEvents.define(this.getContentContainer(),[customEvents.events.scrollBottom])}.bind(this))},PopoverRegionController.prototype.registerListNavigationEventListeners=function(){customEvents.define(this.root,[customEvents.events.down]),this.root.on(customEvents.events.down,function(e,data){this.isMenuOpen()?this.contentItemHasFocus()?this.focusNextContentItem():this.focusFirstContentItem():(this.openMenu(),this.focusFirstContentItem()),data.originalEvent.preventDefault()}.bind(this)),this.promises.navigationHandlers.done(function(){customEvents.define(this.root,[customEvents.events.up,customEvents.events.home,customEvents.events.end]),this.root.on(customEvents.events.up,function(e,data){this.focusPreviousContentItem(),data.originalEvent.preventDefault()}.bind(this)),this.root.on(customEvents.events.home,function(e,data){this.focusFirstContentItem(),data.originalEvent.preventDefault()}.bind(this)),this.root.on(customEvents.events.end,function(e,data){this.focusLastContentItem(),data.originalEvent.preventDefault()}.bind(this))}.bind(this))},PopoverRegionController.prototype.updateFocusItemTabIndex=function(){this.isMenuOpen()?this.menuContainer.find(SELECTORS_CAN_RECEIVE_FOCUS).removeAttr("tabindex"):this.menuContainer.find(SELECTORS_CAN_RECEIVE_FOCUS).attr("tabindex","-1")},PopoverRegionController}));

//# sourceMappingURL=popover_region_controller.min.js.map